#version 120 

attribute vec4 position;
attribute vec4 vertexColor;
attribute vec4 texCoord;

uniform mat4 modelview; 
uniform mat4 projection;
uniform float gamma_inv;

varying vec4 frontColor;
varying vec4 fragTexCoord;
varying float gamma_i;

void main(void)
{
	gamma_i = gamma_inv;
	frontColor = vertexColor;
	fragTexCoord = texCoord;
	gl_Position = projection * modelview * position;
}
